#!/bin/bash

module load anaconda/3
conda activate RelationalNetworks

model=$1
iterations=$2
dim=$3
heads=$4
qk_dim=$5
rules=$6
seed=$7
extras=$8

ext=${extras//\-\-/\_}
ext=${ext// /}

#name="Slots_"$model"_"$iterations"_"$dim"_"$heads"_"$rules""$ext
#
#echo Running version $name
#echo Extra arguments: $extras
#
#python main_slots.py --epochs 100 --relation-type binary --model $model \
#--transformer-dim $dim --n-heads $heads --n-rules $rules \
#--iterations $iterations --name $name $extras #> "out_"$name".log"


name="VIT_"$model"_"$iterations"_"$dim"_"$heads"_"$rules"_"$qk_dim"_"$seed""$ext

echo Running on $HOSTNAME
echo Running version $name
echo Extra arguments: $extras

python main.py --epochs 100 --relation-type binary --model $model \
--transformer-dim $dim --n-heads $heads --n-rules $rules --seed $seed \
--iterations $iterations --name $name --qk-dim $qk_dim $extras #> "out_"$name".log"